(*| 13:29 11/09/1996 *)
PROGRAM BWUart;

USES Crt;

VAR
  I: Integer;

FUNCTION FoundUart(Address: Integer):Boolean;
VAR
  Result: Boolean;
  Temp: Byte;
BEGIN
  Result:=False;
{ IF (Address <> $1F0) THEN BEGIN}
  IF ((Address <> $1F0) AND (Address <> $170)) THEN BEGIN
                                                  { skip hd controller }
    IF (Port[Address+2] AND $38) = 0 THEN BEGIN   { IIR }
      IF (Port[Address+1] AND $E0) = 0 THEN BEGIN { IER }
        Temp:=Port[Address+4];                    { MCR }
        Port[Address+4]:=Temp XOR $1F;
        IF Port[Address+4]=(Temp XOR $1F) THEN
          Result:=True;
        Port[Address+4]:=Temp;
        IF Result THEN BEGIN
          Temp:=Port[Address+7];                  { SCR }
          Port[Address+7]:=Temp XOR $55;
          IF Port[Address+7] <> (Temp XOR $55) THEN
            Result := False;
          Port[Address+7]:=Temp;
        END;
      END;
    END;
  END;
  FoundUart:=Result;
END;  { FoundUart }

PROCEDURE WriteHex(N,Size: Integer);
Var
  I,J,K,Mask: Integer;
BEGIN
  J:=(Size-1)*4;
  Mask:=15 SHL J;
  FOR I:=1 TO Size DO BEGIN
    K:=(N AND Mask) SHR J;
    IF K > 9 THEN
      Write(Chr(K+55))
    ELSE
      Write(K);
    Mask:=Mask SHR 4;
    J:=J-4;
  END;
  Write(' ');
END;

PROCEDURE TestUart(Address: Integer);
BEGIN
  IF FoundUart(Address) THEN BEGIN
    WriteHex(Address,3);
    Writeln(' Found Uart');
  END;
END;

BEGIN
  ClrScr;
  Writeln('Find Uart Program by B Whitnall, v1.2');
  TestUart($3F8);
  TestUart($2F8);
  TestUart($1F0);
  TestUart($170);
  Writeln;
  FOR I:=32 TO 127 DO TestUart(I*8);
  I:=ORD(ReadKey);
END.
